  //
 //  Written by Haazen June 2005
//
using System;
using Server;
using Server.Gumps;
using Server.Network;
using Server.Items;
using Server.Mobiles;
using System.Collections.Generic;
using Server.Misc;
using System.Text;
using Server.Targeting;
using Server.Multis;
using Server.ContextMenus;
using System.Collections;
using Server.Prompts;

namespace Server.Items
{
	public class MonsterContractBook : Item
	{
		private ArrayList m_Entries;
		private int m_DefaultIndex;

		[Constructable]
		public MonsterContractBook( ) : base( 8788 )
		{
			Weight = 1.0;
			LootType = LootType.Blessed;
			Hue = 376;
			Name = "Kniha na lovecke zakazky";

			Layer = Layer.OneHanded;
			m_Entries = new ArrayList();
			m_DefaultIndex = -1;
		}


		public ArrayList Entries
		{
			get
			{
				return m_Entries;
			}
		}

		public MonsterContractBookEntry Default
		{
			get
			{
				if ( m_DefaultIndex >= 0 && m_DefaultIndex < m_Entries.Count )
					return (MonsterContractBookEntry)m_Entries[m_DefaultIndex];

				return null;
			}
			set
			{
				if ( value == null )
					m_DefaultIndex = -1;
				else
					m_DefaultIndex = m_Entries.IndexOf( value );
			}
		}

		public MonsterContractBook( Serial serial ) : base( serial )
		{
		}

		public override bool AllowEquipedCast( Mobile from )
		{
			return true;
		}

		public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
		{
			base.GetContextMenuEntries( from, list );

			if ( from.CheckAlive() && IsChildOf( from.Backpack ) )
				list.Add( new NameBookEntry( from, this ) );
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 1 );

			writer.Write( m_Entries.Count );


			for ( int i = 0; i < m_Entries.Count; ++i )
				((MonsterContractBookEntry)m_Entries[i]).Serialize( writer );
			writer.Write( m_DefaultIndex );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			LootType = LootType.Blessed;

			if( Weight == 3.0 )
				Weight = 1.0;

			int version = reader.ReadInt();

			switch ( version )
			{
				case 1:
				{
					goto case 0;
				}
				case 0:
				{
					int count = reader.ReadInt();

					m_Entries = new ArrayList( count );

					for ( int i = 0; i < count; ++i )
						m_Entries.Add( new MonsterContractBookEntry( reader ) );

					m_DefaultIndex = reader.ReadInt();

					break;
				}
			}
		}

		public void DropContract( Mobile from, MonsterContractBookEntry e, int index )
		{
			if ( m_DefaultIndex == index )
				m_DefaultIndex = -1;

			m_Entries.RemoveAt( index );
			MonsterContract kontrakt = new MonsterContract(e.Monster, e.AmountToKill, e.Reward);
			kontrakt.AmountKilled = e.AmountKilled;	
			from.AddToBackpack( kontrakt );

			from.SendMessage( "Lovecka zakazka byla vyjmuta z knihy" );

		}

      public bool IsOpen( Mobile toCheck )
		{
			NetState ns = toCheck.NetState;

			if ( ns == null )
				return false;

			List<Gump> gumps = ns.Gumps;

			for ( int i = 0; i < gumps.Count; ++i )
			{
				if ( gumps[i] is MonsterContractBookGump )
				{
					MonsterContractBookGump gump = (MonsterContractBookGump)gumps[i];
					return true;
				}
			}

			return false;
		}

		public override bool DisplayLootType{ get{ return Core.AOS; } }

		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( from.InRange( GetWorldLocation(), 1 ) )
			{
				from.CloseGump( typeof( MonsterContractBookGump ) );
				from.SendGump( new MonsterContractBookGump( from, this ) );
			}
		}

		public bool CheckAccess( Mobile m )
		{
			return true;
		}

		public override bool OnDragDrop( Mobile from, Item dropped )
		{
         if ( dropped is MonsterContract )
			{
				if ( !CheckAccess( from ) )
				{
					from.SendLocalizedMessage( 502413 ); // That cannot be done while the book is locked down.
				}
				else if ( IsOpen( from ) )
				{
					from.SendLocalizedMessage( 1005571 ); // You cannot place objects in the book while viewing the contents.
				}
				else if ( m_Entries.Count < 16 )
				{
					MonsterContract kontrakt = (MonsterContract)dropped;

               if ( kontrakt.Monster != null && kontrakt.AmountToKill > 0 && kontrakt.Reward > 0 ) 
  					{
  						m_Entries.Add( new MonsterContractBookEntry( kontrakt.Monster, kontrakt.AmountToKill, kontrakt.Reward, kontrakt.AmountKilled ) );
  						dropped.Delete();
  
  						from.Send( new PlaySound( 0x42, GetWorldLocation() ) );
  
  						return true;
  					}
  					else
  					{
  						from.SendMessage( "Neplatný kontrakt. Kontaktuj Game mastera!" );
  					}
				}
				else
				{
					from.SendMessage( "Kniha je plna" );
				}
			}
			return false;
		}

		private class NameBookEntry : ContextMenuEntry
		{
			private Mobile m_From;
			private MonsterContractBook m_Book;

			public NameBookEntry( Mobile from, MonsterContractBook book ) : base( 6216 )
			{
				m_From = from;
				m_Book = book;
			}

			public override void OnClick()
			{
				if ( m_From.CheckAlive() && m_Book.IsChildOf( m_From.Backpack ) )
				{
					m_From.Prompt = new NameBookPrompt( m_Book );
					m_From.SendLocalizedMessage( 1062479 ); // Type in the new name of the book:
				}
			}
		}

		private class NameBookPrompt : Prompt
		{
			private MonsterContractBook m_Book;

			public NameBookPrompt( MonsterContractBook book )
			{
				m_Book = book;
			}

			public override void OnResponse( Mobile from, string text )
			{
				if ( text.Length > 40 )
					text = text.Substring( 0, 40 );

				if ( from.CheckAlive() && m_Book.IsChildOf( from.Backpack ) )
				{
					m_Book.Name = Utility.FixHtml( text.Trim() );

					from.SendMessage( "Kniha byla prejmenovana" );
				}
			}

			public override void OnCancel( Mobile from )
			{
			}
		}
	}

	public class MonsterContractBookEntry
	{
		private string m_Monster;
		private int m_AmountToKill;
		private int m_Reward;
		private int m_AmountKilled;

		public int Reward
		{
			get{ return m_Reward; }
		}

		public string Monster
		{
			get{ return m_Monster; }
		}
		
		public int AmountToKill
		{
			get{ return m_AmountToKill; }
		}
		
		public int AmountKilled
		{
			get{ return m_AmountKilled; }
			set{ m_AmountKilled = value; }
		}

		public MonsterContractBookEntry( string monster, int amounttokill, int reward, int amountkilled ) 
		{
			m_Monster = monster;
			m_AmountToKill = amounttokill;
			m_Reward = reward;
			m_AmountKilled = amountkilled;
		}

		public MonsterContractBookEntry( GenericReader reader )
		{
			int version = reader.ReadByte();

			switch ( version )
			{
				case 1:
				{
					goto case 0;
				}
				case 0:
				{
					m_Monster = reader.ReadString();
					m_AmountToKill = reader.ReadInt();
					m_Reward = reader.ReadInt();
					m_AmountKilled = reader.ReadInt();
					break;
				}
			}
		}

		public void Serialize( GenericWriter writer )
		{

			writer.Write( (byte) 0 ); // version

			writer.Write( m_Monster );
			writer.Write( m_AmountToKill );
			writer.Write( m_Reward );
			writer.Write( m_AmountKilled );
		}
	}
}